/* CRC-32A version 1.01 by Craig Bruce, 26-Feb-1994
**
**  v1.00: Original release of program, in K&R C.  26-Feb-1993.
**  v1.01: Reformatted and converted to ANSI C.  05-Dec-1994.
**
**  NOTE: This program was superseded by crc32.c a long time ago.
*/

#include <stdio.h>

#define CRC32_GEN   0x04c11db7  /* CCITT standard */
#define CRC32_MSB   0x80000000

int main( int argc, char *argv[] );
unsigned long getcrc( FILE *fp );

/******************************************************************************/
int main( int argc, char *argv[] )
{
    int i;
    FILE *fp;
    unsigned long crc;

    if (argc < 2) {
        crc = getcrc( stdin );
        printf("crc32a = %10lu for <stdin>\n", crc);
    } else {
        for (i=1; i<argc; i++) {
            if ( (fp=fopen(argv[i],"rb")) == NULL ) {
                printf("error opening file \"%s\"!\n", argv[i]);
            } else {
                crc = getcrc( fp );
                printf("crc32a = %10lu for \"%s\"\n", crc, argv[i]);
                fclose( fp );
            }
        }
    }
    return( 0 );
}

/******************************************************************************/
unsigned long getcrc( FILE *fp )
{
    register unsigned long crcbin, crcOverflow;
    int c, i;

    crcbin = 0;
    while( (c=getc(fp)) != EOF ) {
        for (i=0x80; i; i >>= 1) {
            crcOverflow = crcbin & CRC32_MSB;
            crcbin = (crcbin << 1) | (i&c ? 1 : 0);
            if (crcOverflow) crcbin ^= CRC32_GEN;
        }
    }
    return( crcbin );
}
