;ACE-128/64 Dvorak keymatrix, by Craig Bruce - 07-June-1995
;
;this file is in ACE-assembler format.

.org $2000

;The mapping of keyscan matrix positions to keys is as follows:
;
;    \                           COLUMNS:
;ROWS:\
;      \    0       1       2       3       4       5       6       7
;       +-------+-------+-------+-------+-------+-------+-------+-------+ code
;   0   | DELETE| RETURN| RIGHT |  F7   |  F1   |  F3   |  F5   | DOWN  | (0)
;       +-------+-------+-------+-------+-------+-------+-------+-------+
;   1   |   3   |   W   |   A   |   4   |   Z   |   S   |   E   |L-SHIFT| (8)
;       +-------+-------+-------+-------+-------+-------+-------+-------+
;   2   |   5   |   R   |   D   |   6   |   C   |   F   |   T   |   X   | (16)
;       +-------+-------+-------+-------+-------+-------+-------+-------+
;   3   |   7   |   Y   |   G   |   8   |   B   |   H   |   U   |   V   | (24)
;       +-------+-------+-------+-------+-------+-------+-------+-------+
;   4   |   9   |   I   |   J   |   0   |   M   |   K   |   O   |   N   | (32)
;       +-------+-------+-------+-------+-------+-------+-------+-------+
;   5   |   +   |   P   |   L   |   -   |   .   |   :   |   @   |   ,   | (40)
;       +-------+-------+-------+-------+-------+-------+-------+-------+
;   6   |   \   |   *   |   ;   | HOME  |R-SHIFT|   =   |   ^   |   /   | (48)
;       +-------+-------+-------+-------+-------+-------+-------+-------+
;   7   |   1   |   _   |CONTROL|   2   | SPACE |COMMODR|   Q   | STOP  | (56)
;       +-------+-------+-------+-------+-------+-------+-------+-------+
;   8   | HELP  |   8   |   5   |  TAB  |   2   |   4   |   7   |   1   | (64)
;       +-------+-------+-------+-------+-------+-------+-------+-------+
;   9   |  ESC  |   +   |   -   |  LF   | ENTER |   6   |   9   |   3   | (72)
;       +-------+-------+-------+-------+-------+-------+-------+-------+
;  10   |  ALT  |   0   |   .   |  UP   | DOWN  | LEFT  | RIGHT |NO-SCRL| (80)
;       +-------+-------+-------+-------+-------+-------+-------+-------+

;Note that the C128's keyboard has all eleven rows (0-10) whereas the C64's
;keyboard only has the first eight (0-7).  The entires with $00 mean that
;pressing the associated key does nothing.  There are multiple key matrices
;to produce the codes for use with various "shift" keys.

conKeymapNormal = *
   .byte $14,$0d,$1d,$88,$85,$86,$87,$11  ;row 0
   .byte $33,$57,$41,$34,$5a,$53,$45,$01  ;row 1
   .byte $35,$52,$44,$36,$43,$46,$54,$58  ;row 2
   .byte $37,$59,$47,$38,$42,$48,$55,$56  ;row 3
   .byte $39,$49,$4a,$30,$4d,$4b,$4f,$4e  ;row 4
   .byte $2b,$50,$4c,$2d,$2e,$3a,$40,$2c  ;row 5
   .byte $5c,$2a,$3b,$13,$01,$3d,$5e,$2f  ;row 6
   .byte $31,$5f,$04,$32,$20,$02,$51,$03  ;row 7
   .byte $04,$38,$35,$09,$32,$34,$37,$31  ;row 8
   .byte $1b,$2b,$2d,$0a,$0d,$36,$39,$33  ;row 9
   .byte $08,$30,$2e,$91,$11,$9d,$1d,$00  ;row 10

conKeymapShift = *
   .byte $94,$8d,$9d,$8c,$89,$8a,$8b,$91  ;row 0
   .byte $23,$d7,$c1,$24,$da,$d3,$c5,$01  ;row 1
   .byte $25,$d2,$c4,$26,$c3,$c6,$d4,$d8  ;row 2
   .byte $27,$d9,$c7,$28,$c2,$c8,$d5,$d6  ;row 3
   .byte $29,$c9,$ca,$30,$cd,$cb,$cf,$ce  ;row 4
   .byte $db,$d0,$cc,$dd,$3e,$5b,$5f,$3c  ;row 5
   .byte $dc,$c0,$5d,$93,$01,$3d,$de,$3f  ;row 6
   .byte $21,$df,$04,$22,$20,$02,$d1,$83  ;row 7
   .byte $84,$38,$35,$02,$32,$34,$37,$31  ;row 8
   .byte $1b,$2b,$2d,$07,$8d,$36,$39,$33  ;row 9
   .byte $08,$30,$2e,$16,$17,$06,$0b,$00  ;row 10

conKeymapCommodore = *
   .byte $08,$0d,$16,$8f,$80,$82,$84,$17  ;row 0
   .byte $96,$b7,$a1,$97,$ba,$b3,$a5,$01  ;row 1
   .byte $98,$b2,$a4,$99,$a3,$a6,$b4,$b8  ;row 2
   .byte $9a,$b9,$a7,$9b,$a2,$a8,$b5,$b6  ;row 3
   .byte $29,$a9,$aa,$30,$ad,$ab,$af,$ae  ;row 4
   .byte $2b,$b0,$ac,$2d,$3e,$bb,$a0,$3c  ;row 5
   .byte $bc,$7f,$bd,$93,$01,$bf,$be,$3f  ;row 6
   .byte $81,$bf,$04,$95,$5f,$02,$b1,$03  ;row 7
   .byte $84,$38,$35,$18,$32,$34,$37,$31  ;row 8
   .byte $1b,$2b,$2d,$07,$8d,$36,$39,$33  ;row 9
   .byte $08,$30,$2e,$0c,$0f,$10,$15,$00  ;row 10

conKeymapControl = *
   .byte $08,$00,$00,$8f,$80,$82,$84,$00  ;row 0
   .byte $1c,$f7,$e1,$9f,$fa,$f3,$e5,$00  ;row 1
   .byte $9c,$f2,$e4,$1e,$e3,$e6,$f4,$f8  ;row 2
   .byte $1f,$f9,$e7,$9e,$e2,$e8,$f5,$f6  ;row 3
   .byte $12,$e9,$ea,$92,$ed,$eb,$ef,$ee  ;row 4
   .byte $2b,$f0,$ec,$2d,$00,$fb,$e0,$00  ;row 5
   .byte $fc,$60,$fd,$00,$00,$ff,$fe,$00  ;row 6
   .byte $90,$ff,$00,$05,$20,$00,$f1,$00  ;row 7
   .byte $84,$8c,$87,$18,$89,$8a,$88,$85  ;row 8
   .byte $1b,$84,$8f,$0a,$00,$8b,$80,$86  ;row 9
   .byte $08,$82,$2e,$16,$17,$19,$1a,$00  ;row 10

conKeymapAlternate = *
   .byte $08,$0d,$1d,$88,$85,$86,$87,$11  ;row 0
   .byte $33,$77,$61,$34,$7a,$73,$65,$00  ;row 1
   .byte $35,$72,$64,$36,$63,$66,$74,$78  ;row 2
   .byte $37,$79,$67,$78,$62,$68,$75,$76  ;row 3
   .byte $39,$69,$6a,$30,$6d,$6b,$6f,$6e  ;row 4
   .byte $2b,$70,$6c,$2d,$2e,$7b,$ba,$2c  ;row 5
   .byte $a9,$60,$7d,$13,$00,$7f,$7e,$2f  ;row 6
   .byte $31,$7f,$04,$32,$20,$02,$71,$03  ;row 7
   .byte $84,$38,$35,$09,$32,$34,$37,$31  ;row 8
   .byte $1b,$2b,$2d,$0a,$0d,$36,$39,$33  ;row 9
   .byte $08,$30,$2e,$91,$11,$9d,$1d,$00  ;row 10

conKeymapCaps = *
   .byte $14,$0d,$1d,$88,$85,$86,$87,$11  ;row 0
   .byte $33,$d7,$c1,$34,$da,$d3,$c5,$01  ;row 1
   .byte $35,$d2,$c4,$36,$c3,$c6,$d4,$d8  ;row 2
   .byte $37,$d9,$c7,$38,$c2,$c8,$d5,$d6  ;row 3
   .byte $39,$c9,$ca,$30,$cd,$cb,$cf,$ce  ;row 4
   .byte $2b,$d0,$cc,$2d,$2e,$3a,$40,$2c  ;row 5
   .byte $5c,$2a,$3b,$13,$01,$3d,$5e,$2f  ;row 6
   .byte $31,$5f,$04,$32,$20,$02,$d1,$03  ;row 7
   .byte $04,$38,$35,$09,$32,$34,$37,$31  ;row 8
   .byte $1b,$2b,$2d,$0a,$0d,$36,$39,$33  ;row 9
   .byte $08,$30,$2e,$91,$11,$9d,$1d,$00  ;row 10

conKeymapShiftComm = *
   .byte $00,$0d,$16,$00,$00,$00,$00,$17  ;row 0
   .byte $33,$0c,$10,$34,$0f,$15,$1b,$00  ;row 1
   .byte $35,$00,$0e,$36,$00,$00,$09,$00  ;row 2
   .byte $37,$18,$84,$38,$06,$04,$00,$00  ;row 3
   .byte $39,$16,$19,$30,$17,$1a,$00,$0b  ;row 4
   .byte $2b,$07,$0a,$2d,$2e,$10,$00,$2c  ;row 5
   .byte $00,$00,$15,$0c,$00,$00,$00,$04  ;row 6
   .byte $31,$1b,$00,$32,$00,$00,$00,$00  ;row 7
   .byte $04,$38,$35,$09,$32,$34,$37,$31  ;row 8
   .byte $1b,$2b,$2d,$0a,$0d,$36,$39,$33  ;row 9
   .byte $00,$30,$2e,$91,$11,$9d,$1d,$00  ;row 10
